#version 430 core

layout ( triangles ) in;
layout ( triangle_strip, max_vertices = 3) out;

//inputs

layout (location = 0) in vec2  geoTexCoords[];
layout (location = 1) in vec4  geoPosition[];
layout (location = 2) in float  geoCrackDepth[];
layout (location = 3) in float  geoResourceType[];

layout(binding = 0, rgba32f) uniform readonly restrict image2D inputTex;
 
 //outputs
layout (location = 0) out vec3 fragNormal;
layout (location = 1) out vec2  fragTexCoords;
layout (location = 2) out vec4  fragPosLightSpace;
layout (location = 3) out vec4  fragViewPos;
layout (location = 4) out float  fragCrackDepth;
layout (location = 5) out vec3  fragNoiseCoords;
layout (location = 6) out float  fragResourceType;

uniform mat4 view;

vec3 calculateNormal(int location, mat4 MV){

	int primary;
	int secondary;
	int tertiary;

	if(location == 0){
		primary = 0;
		secondary = 1;
		tertiary = 2;
	}else if(location == 1){
		primary = 1;
		secondary = 2;
		tertiary = 0;
	}else if(location == 2){
		primary = 2;
		secondary = 0;
		tertiary = 1;
	}

	vec3 tangent = gl_in[secondary].gl_Position.xyz - gl_in[primary].gl_Position.xyz;
	vec3 bitangent = gl_in[tertiary].gl_Position.xyz - gl_in[primary].gl_Position.xyz;
	vec3 normal = cross(tangent, bitangent);	

	vec3 normalizedNormal = normalize(normal);

	mat3 normalMatrix = transpose(inverse(mat3(MV)));

	return normalize(normalMatrix * normalizedNormal);
}

void main(void){


	mat4 MVP;
	mat4 MV;
	mat4 lightSpaceModel;
		
	MVP[0] = vec4(imageLoad(inputTex, ivec2(0, 0)));
	MVP[1] = vec4(imageLoad(inputTex, ivec2(1, 0)));
	MVP[2] = vec4(imageLoad(inputTex, ivec2(2, 0)));
	MVP[3] = vec4(imageLoad(inputTex, ivec2(3, 0)));

	MV[0] = vec4(imageLoad(inputTex, ivec2(4, 0)));
	MV[1] = vec4(imageLoad(inputTex, ivec2(5, 0)));
	MV[2] = vec4(imageLoad(inputTex, ivec2(6, 0)));
	MV[3] = vec4(imageLoad(inputTex, ivec2(7, 0)));

	lightSpaceModel[0] = vec4(imageLoad(inputTex, ivec2(8, 0)));
	lightSpaceModel[1] = vec4(imageLoad(inputTex, ivec2(9, 0)));
	lightSpaceModel[2] = vec4(imageLoad(inputTex, ivec2(10, 0)));
	lightSpaceModel[3] = vec4(imageLoad(inputTex, ivec2(11, 0)));

	vec3 normal;

	vec4 viewPosition;

	viewPosition = MV * geoPosition[0];
	gl_Position = MVP * geoPosition[0];
	fragViewPos = viewPosition;
	fragNormal = calculateNormal(0, MV);
	fragTexCoords = geoTexCoords[0];
	fragPosLightSpace = lightSpaceModel * geoPosition[0];
	fragCrackDepth = geoCrackDepth[0];
	fragNoiseCoords = normalize(geoPosition[0].xyz);
	fragResourceType = geoResourceType[0];
	EmitVertex();

	viewPosition = MV * geoPosition[1];
	gl_Position = MVP * geoPosition[1];
	fragViewPos = viewPosition;
	fragNormal = calculateNormal(1, MV);
	fragTexCoords = geoTexCoords[1];
	fragPosLightSpace = lightSpaceModel * geoPosition[1];
	fragCrackDepth = geoCrackDepth[1];
	fragNoiseCoords = normalize(geoPosition[1].xyz);
	fragResourceType = geoResourceType[1];
	EmitVertex();

	viewPosition = MV * geoPosition[2];
	gl_Position = MVP * geoPosition[2];
	fragViewPos = viewPosition;
	fragNormal = calculateNormal(2, MV);
	fragTexCoords = geoTexCoords[2];
	fragPosLightSpace = lightSpaceModel * geoPosition[2];
	fragCrackDepth = geoCrackDepth[2];
	fragNoiseCoords = normalize(geoPosition[2].xyz);
	fragResourceType = geoResourceType[2];
	EmitVertex();

	EndPrimitive();

}